/******************************************************************************/
#include "stdafx.h"
/******************************************************************************/
Mesh mbox, // mesh box
     mmb ; // mesh middle barrier
/******************************************************************************/
void InitPre()
{
   App.name="Volumetric Lights";
   App.flag=APP_MS_EXCLUSIVE|APP_FULL_TOGGLE; // mouse exclusive, display can be toggled with Alt+Enter
   PakAdd("../data/engine.pak");

   D.mode(1024,700).volLight(true); // enable volumetric lighting
}
/******************************************************************************/
Bool Init()
{
   Cam.dist=8;

   Material *material=Materials("../data/mtrl/brick/0.mtrl");

   mbox.create(1).B(0).create(Box(3)    ,VTX_TX0|VTX_NRM|VTX_TNG).reverse();
   mmb .create(1).B(0).create(Box(6,1,6),VTX_TX0|VTX_NRM|VTX_TNG);
   // make hole inside 'mmb' by subtracting from it a temporary box (3D geometry subtraction will be used)
   {
      Mshb tmp;
      tmp.create(Box(1),VTX_TX0|VTX_NRM|VTX_TNG); // create temporary box
      mmb.B(0).csg(tmp,SEL_SUB);                  // subtract 'tmp' from 'mmb'

      mmb.setNormals().setTangents().setBinormals(); // re-create normals tangents and binormals
   }

   mbox.setMaterial(material).setRender().setBox();
   mmb .setMaterial(material).setRender().setBox();

   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   CamHandle(2,10,CAMH_ZOOM|CAMH_ROT);
   return true;
}
/******************************************************************************/
void Render()
{
   switch(Renderer())
   {
      case RM_SOLID:
         mbox.draw();
         mmb .draw();
      break;

      case RM_LIGHT: 
         LightPoint(5,Vec(Cos(Tm.time()),1,Sin(Tm.time())),Vec(1), 0.1).add(); // render light with volumetric amount set to 0.1
      break;
      
      case RM_SHD_MAP:
         mbox.draw(); // volumetric lighting depends on shadow map, so we need to render 'mbox' too
         mmb .draw();
      break;
   }
}
void Draw()
{
   Renderer(Render);
}
/******************************************************************************/
